﻿{

    // Arabic Text v2.0
    // Copyright © 2010 - 2011 Salahuddin Taha
    // Scripts:http://aescripts.com/category/scripts/salahuddin-taha-scripts/
    // Email:salah869@hotmail.com
    // Blog:danbawi.wordpress.com
    //
    // This script allaw you to write arabic text using arabic glyphs.
    //
    // Usage:
    // press Clear to erase text from Text Input, you can perform 
    // insert,update or convert operations using DropDownList 
    // and Apply Botton.
    //
    // Note:
    // for new line use CTRL+Enter.
    //
    // Version History:
    // 2.0 added Farsi characters 05/2011 fixes( Blessed for CS5, non-english AE)
    // 1.0 Initial release 03/2010
    
    //Main class
    function ArabicText(){
        var AT = new Object();
        
        AT.scriptName = "Arabic Text";
        AT.scriptVersion = "8.0";
        AT.scriptSupportVersion = "1.0";
        AT.scriptTitle = AT.scriptName+" v"+AT.scriptVersion;
        AT.authorName = "Salahuddin Taha";
        AT.authorBlog = "http://Danbawi.wordpress.com";
        AT.authorScripts = "http://aescripts.com/category/scripts/salahuddin-taha-scripts/";
        AT.authorEmail = "salah869@hotmail.com";
        AT.authorInfo = "Scripts:"+AT.authorScripts+"\\n"+
                                 "Blog:"+AT.authorBlog+"\\n"+
                                 "Email:"+AT.authorEmail;
        AT.scriptCopyright = "Copyright © 2010 - 2011 "+AT.authorName;       
        AT.scriptAbout = "This script allaw you to write arabic text using arabic glyphs.";

        AT.scriptUsage = "  press Clear to erase text from Text Input, you can perform insert,update or convert operations "+
                                  "using DropDownList and Apply Botton.";
        AT.scriptNote =   " for new line use CTRL+Enter ";
        AT.winHelp;
        AT.strClear = "Clear";
        AT.strHelp = "?";
        AT.strBtnHelp1 = "Other Scripts";
        AT.strBtnHelp2 = "My Blog";
        AT.strProcess = "Apply";
        AT.strDwnText = new Array("New Text","Update Text","Convert Text");
        
        AT.valInText = "";
        AT.valSelText = "";
        AT.valOutText = "";
        AT.valTextOpt = -1;
        
        //Building GUI
        function dl_BuildUI(thisObj){
            
            var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", AT.scriptName, undefined, {resizeable:true});
            var res =
            "group { orientation:'column', alignment:['fill','fill'], alignChildren:['right','top'], \
                tool:Group { orientation:'row', alignment:['fill','top'], alignChildren:['right','top'], \
                    btnClear:Button { alignment:['left','top'], text:'"+AT.strClear+"', preferredSize:[70,25]}, \
                    btnHelp:Button { alignment:['right','top'], text:'"+AT.strHelp+"', preferredSize:[25,25]} \
                }, \
                input:Group { orientation:'column', alignment:['fill','fill'], alignChildren:['right','top'], \
                    etxtInput:EditText{ alignment:['fill','fill'], preferredSize:[370,410] , text:'' ,properties:{multiline:true,noecho:false,readonly:false}}\
                }, \
                controls:Group {  orientation:'row', alignment:['fill','bottom'], \
                    dwnText:DropDownList{alignment:['fill','top'],preferredSize:[100,20]},\
                    btnProcess:Button { alignment:['right','top'], text:'"+AT.strProcess+"', preferredSize:[70,25]} \
                } \
              }";
              
            pal.grp = pal.add(res);
            
            //Set the default value for controls
            for(var i=0;i<AT.strDwnText.length;i++)
                pal.grp.controls.dwnText.add("item",AT.strDwnText[i]);
          
            pal.grp.controls.dwnText.selection = 0;
            AT.valTextOpt = pal.grp.controls.dwnText.selection.index;

            //Get input text
            pal.grp.input.etxtInput.onChanging = pal.grp.input.etxtInput.onChange = function (){
                AT.valInText = pal.grp.input.etxtInput.text;
            }

            //Get  text action option
            pal.grp.controls.dwnText.onChange = function (){
                AT.valTextOpt = pal.grp.controls.dwnText.selection.index;
                if(AT.valTextOpt == 2)
                    pal.grp.input.etxtInput.enabled = false;
                else
                    pal.grp.input.etxtInput.enabled = true;
            }       
            
            //when clear button clicked
            pal.grp.tool.btnClear.onClick = function(){
                pal.grp.input.etxtInput.text = "";
            }
        
            //when apply button clicked
            pal.grp.controls.btnProcess.onClick = function(){
                process();
            }
            
            //when help button clicked
            pal.grp.tool.btnHelp.onClick = function(){
                helpWin();
            }
            
            //enable resizing window
            pal.layout.layout(true);
            pal.layout.resize();      
            pal.onResizing = pal.onResize = function () {this.layout.resize();}
            return pal
        }
        
        //The process 
        function process(){
            checkParam(0);
            if(AT.valTextOpt == 0){
                
                checkParam(2);
                AT.valOutText = convertText(AT.valInText);
                AT.valOutText = multiLine (AT.valOutText);
                app.beginUndoGroup("ArabicText");
                var curLayer = app.project.activeItem.layers.addText("01");
                curLayer.property("ADBE Text Properties").property("ADBE Text Document").setValue(AT.valOutText);
                curLayer.name = ""+AT.valInText;
                app.endUndoGroup();
                
            } else 
            if(AT.valTextOpt == 1) { 
                
                checkParam(2);
                checkParam(1);
                AT.valOutText = convertText(AT.valInText);
                AT.valOutText = multiLine (AT.valOutText);
                app.beginUndoGroup("ArabicText");
                var selLayer = app.project.activeItem.selectedLayers;
                for(var i = 0; i<selLayer.length; i++){
                    if(selLayer[i] instanceof TextLayer){
                        selLayer[i].property("ADBE Text Properties").property("ADBE Text Document").setValue(AT.valOutText);
                        selLayer[i].name = ""+AT.valInText;
                    }
                }
                app.endUndoGroup();
            
            } else
            if(AT.valTextOpt == 2) { 
                
                checkParam(1);
                app.beginUndoGroup("ArabicText");
                var selLayer = app.project.activeItem.selectedLayers;
                for(var i = 0; i<selLayer.length; i++){
                    if(selLayer[i] instanceof TextLayer){
                        AT.valSelText = selLayer[i].property("ADBE Text Properties").property("ADBE Text Document").value.toString();
                        AT.valOutText = convertText(AT.valSelText);
                        AT.valOutText = multiLine (AT.valOutText);
                        selLayer[i].property("ADBE Text Properties").property("ADBE Text Document").setValue(AT.valOutText);
                    }
                }
                app.endUndoGroup();              
            }          
        }
    
        function checkParam(ch){
            
            var thisComp = null;
            var selectLayer = null;
            switch(ch){
                case 0:
                    thisComp = app.project.activeItem;
                    if (thisComp == null || !(thisComp instanceof CompItem)){
                        alert ("Please Select A Comp", "Error"); 
                        return;
                    }
                break;
                case 1:
                    selectLayer = app.project.activeItem.selectedLayers;
                    if(selectLayer.length < 1){
                         alert ("Please Select A Layer(s)", "Error");
                         return;
                    } else {
                        var i ;
                        for( i = 0; i<selectLayer.length; i++){
                            if(selectLayer[i] instanceof TextLayer)
                                break;
                        }
                    
                        if(i == selectLayer.length){
                            alert("Please Select A Text Layer(s)", "Error");
                            return;
                        }
                    }
                break;
                case 2:
                    if(AT.valInText == ""){
                        alert ("No Input Text ", "Error");
                        return;
                    }
                break;
                default:
            }
        }
    
        //Hep window configuration
        function helpWin(){
            var pal = new Window("dialog", AT.scriptTitle, undefined, {resizeable:false});
            var res = 
            "group { orientation:'column', alignment:['left','top'], alignChildren:['right','top'], \
                help:Group { alignment:['left','top'],orientation:'column', \
                    txtHead:StaticText { alignment:['left','top'],text:'"+AT.scriptTitle+"'}, \
                    txtCopyright:StaticText { alignment:['left','top'],text:'"+AT.scriptCopyright+"'} \
                    }, \
                group:Group { alignment:['left','top'], \
                    txtDef: EditText { text:' \\n"+AT.scriptAbout+"\\n\\nUsage: "+AT.scriptUsage+"\\n\\nNote: "+AT.scriptNote+"\\n\\n"+AT.authorInfo+"', alignment:['fill','fill'], preferredSize:[300,120], properties:{multiline:true,readonly:true}} \
                    }, \
                controls:Group { alignment:['fill','bottom'], \
                    btnBlog:Button { text:'My Blog', preferredSize:[70,25],alignment:['left','bottom']}, \
                    btnScripts:Button { text:'Scripts', preferredSize:[70,25],alignment:['right','bottom']} \
                } \
            }";
            pal.grp = pal.add(res);
            pal.grp.controls.btnBlog.onClick = function(){
                openUrl(AT.authorBlog);
            }
        
            pal.grp.controls.btnScripts.onClick = function(){
                openUrl(AT.authorScripts);
            }
        
            pal.layout.layout(true);
		   pal.layout.resize();          
            pal.onResizing = pal.onResize = function (){this.layout.resize();}
            pal.center();
            pal.show();
        }
        
        
        function openUrl(url){
            if($.os.indexOf("Windows") != -1)
                    system.callSystem("explorer.exe \""+url+"\"");
                else
                    system.callSystem("open \""+url+"\"");
        }
        
        //Execution function
        this.run = function(thisObj){
            if (parseFloat(app.version) < parseFloat(AT.scriptSupportVersion))
            {
                Window.alert ("This script requires After Effects CS3 or later", "Error", true);
            }
            else
            {
                var win = dl_BuildUI(thisObj);
                if (win != null && win instanceof Window) {
                    win.center();
                    win.show();
                    return 0;
                }
            }	     
        }
        
        function convertText(inTxt){
            var conTxt = "",temp = "",temp2 = "";
            var cur=-1,nxt=-1,prv=-1;
            for(i=1;i<inTxt.length+1;i++){
                
                if(i > 1){
                        nxt = inTxt[inTxt.length-(i-1)];
                        if(check_tashkeel(nxt))
                            nxt = inTxt[inTxt.length-(i-2)];
                    }
                else
                    nxt = -1;
                cur = inTxt[inTxt.length-i];
                //alert(cur+" *** "+ conTxt);
                if(i < inTxt.length){
                    prv = inTxt[inTxt.length-(i+1)];
                    if(check_tashkeel(prv))
                            prv = inTxt[inTxt.length-(i+2)];
                    }
                else
                    prv = -1;
  
                var indx_cur = index_of(form_0,cur);

                if(indx_cur < 0 ){
                    if(inTxt.charCodeAt (inTxt.length-i) == 8204)
                        continue;
                        
                    if(index_of (left_brackets, cur) >= 0)
                        cur = right_brackets[index_of (left_brackets, cur)];
                    else if(index_of (right_brackets, cur) >= 0)
                        cur = left_brackets[index_of (right_brackets, cur)];
                     
                    if(index_of(form_0,prv) >= 0 || inTxt.charCodeAt(inTxt.length-i) == 13 || index_of (spec_char, cur) >=0 || index_of (left_brackets, cur) >= 0 || index_of (right_brackets, cur) >= 0 || prv < 0){
                        if(index_of (spec_char, cur) >= 0 || index_of (left_brackets, cur) >= 0 || index_of (right_brackets, cur) >= 0 || inTxt.charCodeAt(inTxt.length-i) == 13)
                            conTxt += temp + cur;
                        else
                            conTxt += cur + temp;
                        temp = "";
                    }else
                        temp = cur + temp;
                        
               }else if((cur == 'ا' && prv == 'ل')||(cur == 'أ' && prv == 'ل')||(cur == 'إ' && prv == 'ل')||(cur == 'آ' && prv == 'ل'))
                    continue;
                else if(cur == 'ل' && nxt == 'ا' && !check_con(prv))
                    conTxt+='\uFEFB';
                else if(cur == 'ل' && nxt == 'ا' && check_con(prv))
                    conTxt+='\uFEFC';
                else if(cur == 'ل' && nxt == 'أ' && !check_con(prv))
                    conTxt+='\uFEF7';
                else if(cur == 'ل' && nxt == 'أ' && check_con(prv))
                    conTxt+='\uFEF8';
                else if(cur == 'ل' && nxt == 'إ' && !check_con(prv))
                    conTxt+='\uFEF9';
                else if(cur == 'ل' && nxt == 'إ' && check_con(prv))
                    conTxt+='\uFEFA';
                else if(cur == 'ل' && nxt == 'آ' && !check_con(prv))
                    conTxt+='\uFEF5';
                else if(cur == 'ل' && nxt == 'آ' && check_con(prv))
                    conTxt+='\uFEF6';
                else if(!check_con(prv) && index_of(form_0,nxt)<0)     
                    conTxt+=form_0[indx_cur];
                else if(!check_con(prv) && index_of(form_0,nxt)>=0)
                    conTxt+=form_2[indx_cur];
                else if(check_con(prv) && index_of(form_0,nxt)>=0)
                    conTxt+=form_3[indx_cur];
                else if(check_con(prv) && index_of(form_0,nxt)<0)
                    conTxt+=form_1[indx_cur];

            }
            return conTxt;
        }
    
        function multiLine(con_text){
            var push="",pop="",cur="";
            for(g=0;g<con_text.length;g++){
                cur = con_text[g];
                if(cur == '\n' || con_text.charCodeAt(g) == 13){
                    push='\n\r'+pop+push;
                    pop="";
                    }
                else
                    pop+=cur;
                }
            return con_text=pop+push;
        }

        function index_of(arr,ch){
            var indx = -1;
            for(j=0;j<arr.length;j++){
                if(ch==arr[j])
                indx=j;
            }
            return indx;
        }
        
        function check_tashkeel(ch){
            var indx = false;
            var n;
            for(n=0;n<form_0.length;n++){
                if(ch==tashkeel[n])
                indx=true;
            }
            return indx;
        }
    
        function check_con(ch){
            var indx = false;
            for(m=0;m<form_0.length;m++){
                if(ch==form_0[m])
                indx=true;
            }
            for(k=0;k<noncon.length;k++){
                if(ch==noncon[k])
                indx=false;
            }
            return indx;
        }
        
        //Special characters
        var spec_char = ['\n','\n\r',' ','-','.'];
        //Left brackets
        var left_brackets = ['(','{','[','<','«'];
        //Right brackets
        var right_brackets = [')','}',']','>','»'];
        //Tashkeel
        var tashkeel = ['َ','ً','ِ','ٍ','ُ','ٌ','ّ'];
        //
        var noncon = ['ا','ة','د','ذ','ر','ز','و','ى','ؤ','ء','أ','إ','آ','ﮊ','ﭐ','ﮂ','ﮄ','ﮈ','ﮆ','ﮊ','ﮌ','ﮞ','ﮤ','ﯠ','ﯢ','ﯗ','ﯙ','ﯛ','ﯞ','ﮮ','ﮰ','ﻵ','ﻷ','ﻹ','ﻻ'];
        //Isolated form
        var form_0 =  ['ا'     ,'ب'     ,'ة'     ,'ت'     ,'ث'	   ,'ج'     ,'ح'     ,'خ'     ,'د'     ,'ذ'     ,'ر'     ,'ز'     ,'س'     ,'ش'     ,'ص'     ,'ض'     ,'ط'     ,'ظ'     ,'ع'     ,'غ'     ,'ف'     ,'ق'     ,'ك'     ,'ل'     ,'م'     ,'ن'     ,'ه'     ,'و'     ,'ي'     ,'ى'     ,'ؤ'     ,'ئ'     ,'أ'     ,'إ'     ,'آ'     ,'ﭐ'     ,'پ'     ,'چ'     ,'ژ'     ,'گ'     ,'ی'     ,'ک'     ,'ﭦ'     ,'ﭞ'     ,'ﭒ'     ,'ﭖ'     ,'ﭢ'     ,'ﭚ'     ,'ﭲ'     ,'ﭶ'     ,'ﭺ'     ,'ﭾ'     ,'ﮈ'     ,'ﮄ'     ,'ﮂ'     ,'ﮆ'     ,'ﮌ'     ,'ﮊ'     ,'ﭪ'     ,'ﭮ'     ,'ﯓ'     ,'ﮒ'     ,'ﮚ'     ,'ﮖ'     ,'ﮞ'     ,'ﮠ'     ,'ﮪ'     ,'ﮤ'     ,'ﮦ'     ,'ﯠ'     ,'ﯙ'     ,'ﯗ'     ,'ﯛ'     ,'ﯢ'     ,'ﯞ'     ,'ﯼ'     ,'ﯤ'     ,'ﮮ'     ,'ﮰ'     ,'ﻵ'     ,'ﻷ'     ,'ﻹ'     ,'ﻻ'     ,'ـ'     ,'ء'     ];
        //Final form
        var form_1 =  ['\uFE8E','\uFE90','\uFE94','\uFE96','\uFE9A','\uFE9E','\uFEA2','\uFEA6','\uFEAA','\uFEAC','\uFEAE','\uFEB0','\uFEB2','\uFEB6','\uFEBA','\uFEBE','\uFEC2','\uFEC6','\uFECA','\uFECE','\uFED2','\uFED6','\uFEDA','\uFEDE','\uFEE2','\uFEE6','\uFEEA','\uFEEE','\uFEF2','\uFEF0','\uFE86','\uFE8A','\uFE84','\uFE88','\uFE82','\uFB51','\uFB57','\uFB7B','\uFB8B','\uFB93','\uFBFD','\uFB8F','\uFB67','\uFB5F','\uFB53','\uFB57','\uFB63','\uFB5B','\uFB73','\uFB77','\uFB7B','\uFB7F','\uFB89','\uFB85','\uFB83','\uFB87','\uFB8D','\uFB8B','\uFB6B','\uFB6F','\uFBD4','\uFB93','\uFB9B','\uFB97','\uFB9F','\uFBA1','\uFBAB','\uFBA5','\uFBA7','\uFBE1','\uFBDA','\uFBD8','\uFBDC','\uFBE3','\uFBDF','\uFBFD','\uFBE5','\uFBAF','\uFBB1','\uFEF6','\uFEF8','\uFEFA','\uFEFC','\u0640','\u0621'];
        //Initial form
        var form_2 =  ['\uFE8D','\uFE91','\uFE94','\uFE97','\uFE9B','\uFE9F','\uFEA3','\uFEA7','\uFEA9','\uFEAB','\uFEAD','\uFEAF','\uFEB3','\uFEB7','\uFEBB','\uFEBF','\uFEC3','\uFEC7','\uFECB','\uFECF','\uFED3','\uFED7','\uFEDB','\uFEDF','\uFEE3','\uFEE7','\uFEEB','\uFEED','\uFEF3','\uFEEF','\uFE85','\uFE8B','\uFE83','\uFE87','\uFE81','\uFB50','\uFB58','\uFB7C','\uFB8A','\uFB94','\uFBFE','\uFB90','\uFB68','\uFB60','\uFB54','\uFB58','\uFB64','\uFB5C','\uFB74','\uFB78','\uFB7C','\uFB80','\uFB88','\uFB84','\uFB82','\uFB86','\uFB8C','\uFB8A','\uFB6C','\uFB70','\uFBD5','\uFB94','\uFB9C','\uFB98','\uFB9E','\uFBA2','\uFBAC','\uFBA4','\uFBA8','\uFBE0','\uFBD9','\uFBD7','\uFBDB','\uFBE2','\uFBDE','\uFBFE','\uFBE6','\uFBAE','\uFBB0','\uFEF5','\uFEF7','\uFEF9','\uFEFB','\u0640','\u0621'];
        //Medial form
        var form_3 =  ['\uFE8E','\uFE92','\uFE94','\uFE98','\uFE9C','\uFEA0','\uFEA4','\uFEA8','\uFEAA','\uFEAC','\uFEAE','\uFEB0','\uFEB4','\uFEB8','\uFEBC','\uFEC0','\uFEC4','\uFEC8','\uFECC','\uFED0','\uFED4','\uFED8','\uFEDC','\uFEE0','\uFEE4','\uFEE8','\uFEEC','\uFEEE','\uFEF4','\uFEF0','\uFE86','\uFE8C','\uFE84','\uFE88','\uFE82','\uFB51','\uFB59','\uFB7D','\uFB8B','\uFB95','\uFBFF','\uFB91','\uFB69','\uFB61','\uFB55','\uFB59','\uFB65','\uFB5D','\uFB75','\uFB79','\uFB7D','\uFB81','\uFB89','\uFB85','\uFB83','\uFB87','\uFB8D','\uFB8B','\uFB6D','\uFB71','\uFBD6','\uFB95','\uFB9D','\uFB99','\uFB9F','\uFBA3','\uFBAD','\uFBA5','\uFBA9','\uFBE1','\uFBDA','\uFBD8','\uFBDC','\uFBE3','\uFBDF','\uFBFF','\uFBE7','\uFBAE','\uFBB1','\uFEF6','\uFEF8','\uFEFA','\uFEFC','\u0640','\u0621'];
    }

    //Execute main class
    new ArabicText().run(this);


}